<?php
require_once 'config/database.php';

try {
    $db = getDB();

    // Create calendar_events table
    $sql = "
        CREATE TABLE IF NOT EXISTS calendar_events (
            id INT AUTO_INCREMENT PRIMARY KEY,
            title VARCHAR(255) NOT NULL,
            description TEXT,
            event_date DATE NOT NULL,
            event_time TIME DEFAULT '09:00',
            creator_id INT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (creator_id) REFERENCES users(id) ON DELETE SET NULL,
            INDEX idx_event_date (event_date),
            INDEX idx_creator (creator_id)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ";

    $db->exec($sql);
    echo "Calendar events table created successfully!\n";

    // Add event_time column if it doesn't exist (for existing tables)
    try {
        $alterSql = "ALTER TABLE calendar_events ADD COLUMN IF NOT EXISTS event_time TIME DEFAULT '09:00'";
        $db->exec($alterSql);
        echo "Event time column added/verified successfully!\n";
    } catch (Exception $e) {
        echo "Note: Event time column may already exist or alter failed: " . $e->getMessage() . "\n";
    }

} catch (PDOException $e) {
    echo "Error creating calendar events table: " . $e->getMessage() . "\n";
}
?>